unit NrRomanos;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Math, Tabnotbk, ComCtrls, Buttons, StdCtrls, ExtCtrls;

type
  TFNrRomanos = class(TForm)
    Label3: TLabel;
    Label1: TLabel;
    Arabico: TEdit;
    Label2: TLabel;
    Romano: TEdit;
    btnConverterArabToRom: TBitBtn;
    Label4: TLabel;
    Label5: TLabel;
    Panel: TPanel;
    Visor: TEdit;
    bI: TSpeedButton;
    bV: TSpeedButton;
    bX: TSpeedButton;
    bMais: TSpeedButton;
    bL: TSpeedButton;
    bC: TSpeedButton;
    bD: TSpeedButton;
    bMenos: TSpeedButton;
    bM: TSpeedButton;
    bVezes: TSpeedButton;
    bDividir: TSpeedButton;
    bIgual: TSpeedButton;
    Notebook: TTabbedNotebook;
    bVoltar: TSpeedButton;
    bRecomecar: TSpeedButton;
    VisorArab: TEdit;
    btnConverterRomToArab: TBitBtn;
    procedure btnConverterArabToRomClick(Sender: TObject);
    procedure RomanoKeyPress(Sender: TObject; var Key: Char);
    procedure bMaisClick(Sender: TObject);
    procedure bVezesClick(Sender: TObject);
    procedure bDividirClick(Sender: TObject);
    procedure bMenosClick(Sender: TObject);
    procedure bIgualClick(Sender: TObject);
    procedure bVoltarClick(Sender: TObject);
    procedure bRecomecarClick(Sender: TObject);
    procedure bIClick(Sender: TObject);
    procedure bVClick(Sender: TObject);
    procedure bLClick(Sender: TObject);
    procedure bXClick(Sender: TObject);
    procedure bCClick(Sender: TObject);
    procedure bDClick(Sender: TObject);
    procedure bMClick(Sender: TObject);
    procedure VisorChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure ArabicoKeyPress(Sender: TObject; var Key: Char);
    procedure btnConverterRomToArabClick(Sender: TObject);
  private
    Operador : String;
    Num1 : integer;
    Num2 : integer;
    procedure OperadorClick(Op:string);
    procedure AlgarismoClick(Alg:string);
    function ConverteVisor : integer;
    function ArabicoToRomano(Arabico:Integer): String;
    function RomanoToArabico(Romano:string):integer;
    function valida_nralgarismos(Romano:string):boolean;
    function valida_posAlgarismos(Romano:string):boolean;
  public
    { Public declarations }
  end;

var
  FNrRomanos: TFNrRomanos;

implementation

{$R *.DFM}

function TFNrRomanos.ArabicoToRomano(Arabico:Integer): String;
//Converte um numero decimal em algarismos romanos
const
Romanos:  Array[1..13] of String = ( 'I', 'IV', 'V', 'IX', 'X', 'XL', 'L', 'XC', 'C', 'CD', 'D', 'CM', 'M' );
Arabicos: Array[1..13] of Integer =( 1, 4, 5, 9, 10, 40, 50, 90, 100, 400, 500, 900, 1000);
var
i: Integer;
s: String;
begin
  s := '';
  for i := 13 downto 1 do
    while ( Arabico >= Arabicos[i] ) do
           begin
           Arabico := Arabico - Arabicos[i];
           s := s + Romanos[i];
           end;
   ArabicoToRomano := s;
end;

procedure TFNrRomanos.btnConverterArabToRomClick(Sender: TObject);
var i : integer;
begin
i:=0;

if trim(arabico.text) = '' then
begin
    Romano.Clear;
    abort;
end;
try
    i := strtoint(trim(arabico.text));
except
    on EConvertError do
    begin
        messagedlg('Nmero invlido',mtinformation,[mbok],0);
        romano.Clear;
        abort;
    end;
end;
if i > 3999 then
begin
    arabico.text := '3999';
    i := 3999;
end;
romano.text := ArabicoToRomano(i);
Arabico.SetFocus;
end;

function TFNrRomanos.RomanoToArabico(Romano:string):integer;
var
    i, // variavel que vai percorrer a string recebida
    milhares,centenas,dezenas,unidades,total :integer;
begin
milhares := 0;
centenas := 0;
dezenas := 0;
unidades := 0;
total := 0;

if (not valida_nralgarismos(Romano)) or (not valida_posAlgarismos(Romano)) then
begin
    RomanoToArabico := -1;
    exit;
end;

i:=1;
while i <= length(Romano) do
begin
    // milhares
    while Romano[i] = 'M' do
    begin
        inc(milhares);
        inc(i);
    end;
    total := milhares * 1000;

    // centenas
    if (copy (Romano,i,2) = 'CM') then
    begin
        centenas := 9;
        inc(i,2);
    end
    else if (copy (Romano,i,1) = 'D') then
    begin
        centenas := 5;
        inc(i);
    end
    else if (copy (Romano,i,2) = 'CD') then
    begin
        centenas := 4;
        inc(i,2);
    end;

    if (centenas = 0) or (centenas = 5) then
        while (Romano[i] = 'C') do
        begin
            inc(centenas);
            inc(i);
        end;

    total := total + (centenas * 100);

    // dezenas
    if (copy (Romano,i,2) = 'XC') then
    begin
        dezenas := 9;
        inc(i,2);
    end
    else if (copy(Romano,i,1) = 'L') then
    begin
        dezenas := 5;
        inc(i);
    end
    else if (copy(Romano,i,2) = 'XL') then
    begin
        dezenas := 4;
        inc(i,2);
    end;

    if (dezenas = 0) or (dezenas = 5) then
        while (Romano[i] = 'X') do
        begin
            inc(dezenas);
            inc(i);
        end;

    total := total + (dezenas * 10);

    // unidades
    if (copy(Romano,i,2) = 'IX') then
    begin
        unidades := 9;
        inc(i,2);
    end
    else if (copy(Romano,i,1) = 'V') then
    begin
        unidades := 5;
        inc(i);
    end
    else if (copy(Romano,i,2) = 'IV') then
    begin
        unidades := 4;
        inc(i,2);
    end;

    if (unidades = 0) or (unidades = 5) then
        while (Romano[i] = 'I') do
        begin
            inc(unidades);
            inc(i);
        end;

    total := total + unidades;

end;
RomanoToArabico := total;
end;

procedure TFNrRomanos.RomanoKeyPress(Sender: TObject; var Key: Char);
// nao deixando o usuario digitar algarismos invalidos na caixa dos algarismos romanos
// deixando passar somente as letras representativas de algarismos romanos e algumas
// teclas de controle como por exemplo: DEL,ENTER...
begin
if key = #13 then
    btnConverterRomToArab.Click
else
if  not (key in ['I','V','X','L','C','D','M','i','v','x','l','c','d','m']) and
    not (ord(key) in [VK_BACK,VK_TAB,VK_RETURN,VK_ESCAPE,VK_END,
                      VK_HOME,VK_LEFT,VK_RIGHT,VK_DELETE]) then
    key := #0;
end;

// funcao que verifica a quantidade de vezes que um
// algarismo aparece no nr romano
// p.e: false se tiver quatro 'I's no nr romano
function TFNrRomanos.valida_nralgarismos(Romano:string):boolean;
var
    i,
    cont_I,
    cont_V,
    cont_X,
    cont_L,
    cont_C,
    cont_D,
    cont_M : integer;
begin
cont_I := 0;
cont_V := 0;
cont_X := 0;
cont_L := 0;
cont_C := 0;
cont_D := 0;
cont_M := 0;

for i := 1 to Length(Romano) do
begin
    case Romano[i] of
      'M': inc(cont_M);
      'D': inc(cont_D);
      'C': inc(cont_C);
      'L': inc(cont_L);
      'X': inc(cont_X);
      'V': inc(cont_V);
      'I': inc(cont_I);
    end;
end;

valida_nralgarismos := (cont_I <=3) and
                       (cont_V <=1) and
                       (cont_X <=3) and
                       (cont_L <=1) and
                       (cont_C <=3) and
                       (cont_D <=1) and
                       (cont_M <=3);
end;

// funcao que verifica o posicionamento dos algarismos
// p.e: false se algum 'I' estiver antes de um 'C'
function TFNrRomanos.valida_posAlgarismos(Romano:string):boolean;
var i: integer; // variavel usada no for
    b: boolean; // variavel que recebera o resultado da funcao
    Romanos : TStringList; // Objeto que conter a lista de algarismos romanos
    ParesInversosValidos : TStringList; // Objeto que conter a lista de pares de algarismos que podem ser inversos, p.e: o par que representa o Arabico 4 (IV)
begin
Romanos := TStringList.Create;
ParesInversosValidos := TStringList.Create;
// preenchendo o objeto com os algarismos romanos
Romanos.Add('I'); // arabico 1
Romanos.Add('V'); // arabico 5
Romanos.Add('X'); // arabico 10
Romanos.Add('L'); // arabico 50
Romanos.Add('C'); // arabico 100
Romanos.Add('D'); // arabico 500
Romanos.Add('M'); // arabico 1000

// preenchendo o objeto com a lista de pares inversos validos
ParesInversosValidos.Add('IV'); // arabico 4
ParesInversosValidos.Add('IX'); // arabico 9
ParesInversosValidos.Add('XL'); // arabico 40
ParesInversosValidos.Add('XC'); // arabico 90
ParesInversosValidos.Add('CD'); // arabico 400
ParesInversosValidos.Add('CM'); // arabico 900

b := true; // primeiro dizemos que o nr romano esta valido, no proximo for tentaremos provar o contrario

for i := 1 to (length(Romano)-1) do // percorrendo o nr Romano at seu penultimo algarismo
begin
    if Romanos.indexof(Romano[i]) < Romanos.indexof(Romano[i+1]) then // se o algarismo da esquerda for menor que o da direita..
    begin
        if ParesInversosValidos.IndexOf(Romano[i]+Romano[i+1]) = -1 then // se nao esses dois algarismos em questao, nao estiverem no conjunto de 'pares inversos vlidos'..
            b := false; // o nr romano eh falso 
    end;
end;

// verificando a existencia de combinacoes do tipo: 'CMM' ou 'IXI', que escapam das outras validacoes
if length(Romano) > 2 then // somente se o nr romano tem mais que dois algarismos
begin
    for i := 1 to (length(Romano)-2) do // percorrendo o nr Romano at seu antepenultimo algarismo
    begin
        if  Romanos.indexof(Romano[i]) < Romanos.indexof(Romano[i+2]) then // evitando casos do tipo 'CMM'
            b := false; // o nr romano eh falso
        if  (Romanos.indexof(Romano[i]) = Romanos.indexof(Romano[i+2])) and
            (Romanos.indexof(Romano[i]) < Romanos.indexof(Romano[i+1])) then // evitando casos do tipo 'IXI', mas nao podemos evitar 'III' nem 'XIX' !!
            b := false; // o nr romano eh falso
    end;
end;
Romanos.Destroy;
ParesInversosValidos.Destroy;
valida_posAlgarismos := b;
end;

// funcao que converte o Romano do visor, e faz todos os tratamentos
function TFNrRomanos.ConverteVisor: integer;
var i:integer;
begin
if (Visor.Text = '') then
    i := 0
else
    if (Visor.text)[1] = '-' then
    begin
        i := RomanoToArabico(copy(Visor.Text,2,length(Visor.Text)-1));
        i := i * -1;
    end
    else
    begin
        i := RomanoToArabico(Visor.Text);
    end;

if i = -1 then
begin
    messagedlg('Nmero invlido',mtinformation,[mbok],0);
    Visor.Text := copy(Visor.Text,1,length(Visor.Text)-1); // tirando o algarismo invlido
    abort;
end;
ConverteVisor:=i;
end;

procedure TFNrRomanos.AlgarismoClick(Alg: string);
begin
if (Operador = '=') then
begin
    if Num1 = 0 then
        Visor.Clear;
//    Operador := '';
    Visor.text := Visor.text + Alg;
    Num1 := strtoint(VisorArab.Text);
end
else
begin
    if (Num2 = 0) then
        Visor.Clear;
    Visor.text := Visor.text + Alg;
    Num2 := strtoint(VisorArab.Text);
end;
end;

procedure TFNrRomanos.OperadorClick(Op: string);
begin
if Operador <> '=' then // se o usuario nao digitar o igual, ns digitamos pra ele!!
    bIgual.Click;
Num1 := ConverteVisor;
Operador := Op;
end;

procedure TFNrRomanos.bMaisClick(Sender: TObject);
begin
OperadorClick('+');
end;

procedure TFNrRomanos.bVezesClick(Sender: TObject);
begin
OperadorClick('*');
end;

procedure TFNrRomanos.bDividirClick(Sender: TObject);
begin
OperadorClick('/');
end;

procedure TFNrRomanos.bMenosClick(Sender: TObject);
begin
OperadorClick('-');
end;

procedure TFNrRomanos.bIgualClick(Sender: TObject);
var Total : Integer;
begin
if (Operador = '') then
    abort;

total := 0;
if  (Operador = '+') then
    Total := Num1 + Num2
else if  (Operador = '-') then
    Total := Num1 - Num2
else if  (Operador = '*') then
    Total := Num1 * Num2
else if  (Operador = '/') then
    Total := floor(Num1 / Num2); // nao existe zero em romano, entao nao precisa validar

Operador := '=';
Num1 := 0;
Num2 := 0;
if total < 0 then
begin
    total := total * -1;
    Visor.Text := '-'+ArabicoToRomano(total);
end
else
    if Total > 3999 then
       Total := 3999; 
    Visor.text := ArabicoToRomano(total);
end;

procedure TFNrRomanos.bVoltarClick(Sender: TObject);
begin
Visor.Text := Copy(Visor.Text,1,length(Visor.Text)-1);
end;

procedure TFNrRomanos.bRecomecarClick(Sender: TObject);
begin
Visor.Clear;
Operador := '=';
Num1 := 0;
Num2 := 0;
end;

procedure TFNrRomanos.bIClick(Sender: TObject);
begin
AlgarismoClick('I');
end;

procedure TFNrRomanos.bVClick(Sender: TObject);
begin
AlgarismoClick('V');
end;

procedure TFNrRomanos.bLClick(Sender: TObject);
begin
AlgarismoClick('L');
end;

procedure TFNrRomanos.bXClick(Sender: TObject);
begin
AlgarismoClick('X');
end;

procedure TFNrRomanos.bCClick(Sender: TObject);
begin
AlgarismoClick('C');
end;

procedure TFNrRomanos.bDClick(Sender: TObject);
begin
AlgarismoClick('D');
end;

procedure TFNrRomanos.bMClick(Sender: TObject);
begin
AlgarismoClick('M');
end;

procedure TFNrRomanos.VisorChange(Sender: TObject);
begin
VisorArab.Text := inttostr(ConverteVisor);
end;

procedure TFNrRomanos.FormCreate(Sender: TObject);
begin
Operador := '=';
Num1 := 0;
Num2 := 0;
Notebook.PageIndex := 0;
end;

procedure TFNrRomanos.FormKeyPress(Sender: TObject; var Key: Char);
begin
if (Notebook.PageIndex <> 0) then exit; // s vale para a calculadora

case Key of
  'I','i': bI.Click;
  'V','v': bV.Click;
  'X','x': bX.Click;
  'L','l': bL.Click;
  'C','c': bC.Click;
  'D','d': bD.Click;
  'M','m': bM.Click;
  '+': bMais.Click;
  '-': bMenos.Click;
  '*': bVezes.Click;
  '/': bDividir.Click;
  '=': bIgual.Click;
  chr(vk_Return) : bIgual.Click;
  chr(vk_Back) : bVoltar.Click;
  chr(vk_Escape) : bRecomecar.Click;
end;
end;

procedure TFNrRomanos.ArabicoKeyPress(Sender: TObject; var Key: Char);
begin
if key = #13 then
    btnConverterArabToRom.Click;
end;

procedure TFNrRomanos.btnConverterRomToArabClick(Sender: TObject);
var i : integer;
begin
i := RomanoToArabico(trim(romano.text));
if i = -1 then
begin
    messagedlg('Nmero invlido',mtinformation,[mbok],0);
    arabico.Clear;
    romano.text := copy(romano.text,1,length(romano.text)-1);
    abort;
end;
arabico.text := inttostr(i);
Romano.SetFocus;
end;

end.
